#ifndef _CNT_ARRAYLIST_H_
#define _CNT_ARRAYLIST_H_

#include <assert.h>
#include <stdio.h>

typedef struct cntArray_s cntArray_t;
cntArray_t *Array_Alloc(int elementSize, int initialNum);
void Array_Free(cntArray_t *ar);
void Array_SetGrowth(cntArray_t *ar, bool exponential);
void Array_QSort(cntArray_t *ar, int (__cdecl * compareFunc)(const void *a, const void *b));
void *Array_GetElement(cntArray_t *ar, int index);
void *Array_GetElementGrow(cntArray_t *ar, int index);
void Array_Append(cntArray_t *ar, void *element);
void Array_RemoveLast(cntArray_t *ar);
void Array_Insert(cntArray_t *ar, void *element, int index);
void Array_Remove(cntArray_t *ar, int index);
int Array_GetCount(cntArray_t *ar);
void Array_Reset(cntArray_t *ar);
void Array_Tighten(cntArray_t *ar);

//quick and dirty class encapsulation of array
template<class classType>
class CArrayList
{
public:
	CArrayList()
	{
		m_array = NULL;
	}

	~CArrayList()
	{
		Clear();
	}

	void CopyTo(CArrayList<classType> &from)
	{
		Clear();
		if (!from.m_array || from.Num() <= 0)
		{
			return;
		}
		m_array = Array_Alloc(sizeof(classType), from.Num());
		Array_SetGrowth(m_array, true);
		for (int i = 0; i < from.Num(); i++)
		{
			Append(from[i]);
		}
	}

	inline int Num(void)
	{
		if (!m_array)
		{
			return 0;
		}
		return Array_GetCount(m_array);
	}

	inline void Clear(void)
	{
		if (m_array)
		{
			Array_Free(m_array);
			m_array = 0;
		}
	}

	inline void Reset(void)
	{ //resets without freeing the array
		if (m_array)
		{
			Array_Reset(m_array);
		}
	}

	inline void SetGrowth(bool exponential)
	{
		CheckAlloc();
		Array_SetGrowth(m_array, exponential);
	}

	inline void QSort(int (__cdecl * compareFunc)(const void *a, const void *b))
	{
		if (m_array)
		{
			Array_QSort(m_array, compareFunc);
		}
	}

	inline int Find(classType &p, bool add = true)
	{
		CheckAlloc();
		int csize = sizeof(classType);
		int cnum = Num();
		for (int i = 0; i < cnum; i++)
		{
			classType *a = (classType *)Array_GetElementGrow(m_array, i);
			classType *b = &p;
			if (!memcmp(a, b, csize))
			{
				return i;
			}
		}
		if (!add)
		{
			return -1;
		}
		int r = Num();
		Append(p);
		return r;
	}

	inline void Append(classType &p)
	{
		Push(p);
	}

	inline void Push(classType &p)
	{
		CheckAlloc();
		Array_Append(m_array, &p);
	}

	inline void Pop(void)
	{
		CheckAlloc();
		Array_RemoveLast(m_array);
	}

	inline void RemoveIndex(int index)
	{
		CheckAlloc();
		Array_RemoveLast(m_array);
	}

	inline classType &operator[](int index)
	{
		CheckAlloc();
		classType *t = (classType *)Array_GetElementGrow(m_array, index);
		return *t;
	}

private:
	inline void CheckAlloc(void)
	{
		if (m_array)
		{
			return;
		}
		m_array = Array_Alloc(sizeof(classType), 4096);
		Array_SetGrowth(m_array, true);
	}

	cntArray_t		*m_array;
};
#endif //_CNT_ARRAYLIST_H_