//stream container
#ifndef _CNT_BITSTREAM_H
#define _CNT_BITSTREAM_H

#include <assert.h>
#include <stdio.h>

typedef struct cntStream_s cntStream_t;
cntStream_t *Stream_Alloc(void *buffer, int size);
void Stream_Free(cntStream_t *st);
void Stream_WriteBits(cntStream_t *st, void *buf, int size);
void Stream_WriteBytes(cntStream_t *st, void *buf, int size);
bool Stream_ReadBits(cntStream_t *st, void *buf, int size);
bool Stream_ReadBytes(cntStream_t *st, void *buf, int size);
void Stream_WriteBool(cntStream_t *st, bool val);
void Stream_WriteInt(cntStream_t *st, int val);
void Stream_WriteFloat(cntStream_t *st, float val);
void Stream_WriteString(cntStream_t *st, char *str, bool noTerminate = false);
bool Stream_ReadBool(cntStream_t *st);
int Stream_ReadInt(cntStream_t *st);
float Stream_ReadFloat(cntStream_t *st);
void Stream_ReadString(cntStream_t *st, char *str, int maxSize);
void *Stream_Buffer(cntStream_t *st);
int Stream_Size(cntStream_t *st);
void Stream_SetOffset(cntStream_t *st, int offset);
int Stream_GetOffset(cntStream_t *st);

class RichBitStream
{
public:
	RichBitStream()
	{
		m_stream = Stream_Alloc(NULL, 1048576);
	}
	RichBitStream(void *data, int dataSize)
	{
		m_stream = Stream_Alloc(data, dataSize);
	}
	~RichBitStream()
	{
		if (m_stream)
		{
			Stream_Free(m_stream);
			m_stream = NULL;
		}
	}

	void WriteBits(void *src, int numBits)
	{
		assert(m_stream);
		Stream_WriteBits(m_stream, src, numBits);
	}
	void WriteBytes(void *src, int size)
	{
		assert(m_stream);
		Stream_WriteBytes(m_stream, src, size);
	}
	bool ReadBits(void *dst, int numBits)
	{
		assert(m_stream);
		return Stream_ReadBits(m_stream, dst, numBits);
	}
	int ReadBits(int numBits)
	{
		assert(m_stream);
		int rv = 0;
		Stream_ReadBits(m_stream, &rv, numBits);
		return rv;
	}
	bool ReadBytes(void *dst, int size)
	{
		assert(m_stream);
		return Stream_ReadBytes(m_stream, dst, size);
	}

	void WriteBool(bool val)
	{
		assert(m_stream);
		Stream_WriteBool(m_stream, val);
	}
	void WriteInt(int val)
	{
		assert(m_stream);
		Stream_WriteInt(m_stream, val);
	}
	void WriteFloat(float val)
	{
		assert(m_stream);
		Stream_WriteFloat(m_stream, val);
	}
	void WriteString(char *str)
	{
		assert(m_stream);
		Stream_WriteString(m_stream, str, true);
	}
	void WriteStringVA(const char *fmt, ...)
	{
		assert(m_stream);
		char finalString[16384];
		va_list args;
		va_start(args, fmt);
		vsprintf_s(finalString, 16000, fmt, args);
		va_end(args);
		Stream_WriteString(m_stream, finalString, true);
	}
	//nul-terminated string
	void WriteStringNulTerm(char *str)
	{
		assert(m_stream);
		Stream_WriteString(m_stream, str);
	}

	bool ReadBool(void)
	{
		assert(m_stream);
		return Stream_ReadBool(m_stream);
	}
	int ReadInt(void)
	{
		assert(m_stream);
		return Stream_ReadInt(m_stream);
	}
	float ReadFloat(void)
	{
		assert(m_stream);
		return Stream_ReadFloat(m_stream);
	}
	void ReadString(char *str, int maxSize)
	{
		assert(m_stream);
		return Stream_ReadString(m_stream, str, maxSize);
	}

	void *GetBuffer(void)
	{
		assert(m_stream);
		return Stream_Buffer(m_stream);
	}
	int GetSize(void)
	{
		assert(m_stream);
		return Stream_Size(m_stream);
	}

	void SetOffset(int ofs)
	{
		assert(m_stream);
		Stream_SetOffset(m_stream, ofs);
	}
	int GetOffset(void)
	{
		assert(m_stream);
		return Stream_GetOffset(m_stream);
	}

protected:
	cntStream_t		*m_stream;
};
#endif //_CNT_BITSTREAM_H
