//random shared functionality.
#include <windows.h>
#include "cnt_arraylist.h"
#include "cnt_bitstream.h"
#include "pluginshare.h"

modelMatrix_t g_identityMatrix =
{
	{1.0f, 0.0f, 0.0f},
	{0.0f, 1.0f, 0.0f},
	{0.0f, 0.0f, 1.0f},
	{0.0f, 0.0f, 0.0f}
};

fourxMatrix_t g_identityMatrix4x4 =
{
	{1.0f, 0.0f, 0.0f, 0.0f},
	{0.0f, 1.0f, 0.0f, 0.0f},
	{0.0f, 0.0f, 1.0f, 0.0f},
	{0.0f, 0.0f, 0.0f, 1.0f}
};

double g_dbPI = 3.14159265358979323846;
float g_flPI = (float)g_dbPI;
float g_flDegToRad = g_flPI / 180.0f;
float g_flRadToDeg = 180.0f / g_flPI;

void SafeStrCopy(char *dst, int dstLen, char *src)
{
	int i;
	for (i = 0; src[i] && i < dstLen-1; i++)
	{
		dst[i] = src[i];
	}
	dst[i] = 0;
}

int AlignInt(int val, int alignTo)
{
	int d = val%alignTo;
	if (d != 0)
	{
		val += (alignTo-d);		
	}
	return val;
}

//get signed bits
int SignedBits(int val, int bits)
{
	int signVal = (1<<(bits-1));
	bool isSign = !!(val & signVal);
	if (isSign)
	{
		val ^= signVal;
		val = -(signVal-val);
	}

	return val;
}

WORD GetBigWord(WORD w)
{
	WORD r = w;
	BYTE *m = (BYTE *)&r;
	BYTE t = m[0];
	m[0] = m[1];
	m[1] = t;
	return r;
}

WORD GetBigWordRaw(BYTE *b)
{
	return GetBigWord(*((WORD *)b));
}

int GetBigInt(int dw)
{
	int r = dw;
	BYTE *m = (BYTE *)&r;
	BYTE t[2] = {m[0], m[1]};
	m[0] = m[3];
	m[1] = m[2];
	m[2] = t[1];
	m[3] = t[0];
	return r;
}

int GetBigIntRaw(BYTE *b)
{
	return GetBigInt(*((int *)b));
}

void LittleBigSwap(void *in, int numBytes)
{
	BYTE *data = (BYTE *)in;
	if (numBytes == 8)
	{
		BYTE t[4] = {data[0], data[1], data[2], data[3]};
		data[0] = data[7];
		data[1] = data[6];
		data[2] = data[5];
		data[3] = data[4];
		data[4] = t[3];
		data[5] = t[2];
		data[6] = t[1];
		data[7] = t[0];
	}
	else if (numBytes == 4)
	{
		BYTE t[2] = {data[0], data[1]};
		data[0] = data[3];
		data[1] = data[2];
		data[2] = t[1];
		data[3] = t[0];
	}
	else if (numBytes == 2)
	{
		BYTE t = data[0];
		data[0] = data[1];
		data[1] = t;
	}
}

size_t fseekread(__int64 ofs, void *dst, size_t elementSize, size_t count, FILE *file)
{
	_fseeki64(file, ofs, SEEK_SET);
	return fread(dst, elementSize, count, file);
}
int freadint(FILE *file, bool bigEnd)
{
	int i = 0;
	fread(&i, sizeof(int), 1, file);
	if (bigEnd)
	{
		LITTLE_BIG_SWAP(i);
	}
	return i;
}
int fseekreadint(__int64 ofs, FILE *file, bool bigEnd)
{
	_fseeki64(file, ofs, SEEK_SET);
	return freadint(file, bigEnd);
}
short freadshort(FILE *file, bool bigEnd)
{
	short i = 0;
	fread(&i, sizeof(short), 1, file);
	if (bigEnd)
	{
		LITTLE_BIG_SWAP(i);
	}
	return i;
}
short fseekreadshort(__int64 ofs, FILE *file, bool bigEnd)
{
	_fseeki64(file, ofs, SEEK_SET);
	return freadshort(file, bigEnd);
}
