#ifndef _NOESIS_PLUGIN_SHARE_H
#define _NOESIS_PLUGIN_SHARE_H

//general rule is, don't change anything in this file.

// Modify the following defines if you have to target a platform prior to the ones specified below.
// Refer to MSDN for the latest info on corresponding values for different platforms.
#ifndef WINVER				// Allow use of features specific to Windows XP or later.
#define WINVER 0x0501		// Change this to the appropriate value to target other versions of Windows.
#endif

#ifndef _WIN32_WINNT		// Allow use of features specific to Windows XP or later.                   
#define _WIN32_WINNT 0x0501	// Change this to the appropriate value to target other versions of Windows.
#endif						

#ifndef _WIN32_WINDOWS		// Allow use of features specific to Windows 98 or later.
#define _WIN32_WINDOWS 0x0410 // Change this to the appropriate value to target Windows Me or later.
#endif

#ifndef _WIN32_IE			// Allow use of features specific to IE 6.0 or later.
#define _WIN32_IE 0x0600	// Change this to the appropriate value to target other versions of IE.
#endif

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
// Windows Header Files:
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <assert.h>

#define NOESIS_PLUGIN_VERSION		3

#define NOESIS_PLUGINAPI_VERSION	23 //make your plugin require this version if you use new api functions.
//Noesis 3.31 - 23
//Noesis 3.28 - 22
//Noesis 3.27 - 21
//Noesis 3.26 - 20
//Noesis 3.22 - 19
//Noesis 3.17 - 18
//Noesis 3.15 - 17
//Noesis 3.1 - 16
//Noesis 3.0 - 15
//Noesis 2.99 - 14
//Noesis 2.981 - 13
//Noesis 2.97 - 12
//Noesis 2.95 - 11
//Noesis 2.9 - 10
//Lower than Noesis 2.9 - 9

#define MAX_NOESIS_PATH				4096

typedef unsigned int noesisIntPtr_t;

extern void SafeStrCopy(char *dst, int dstLen, char *src);
extern int AlignInt(int val, int alignTo);
extern int SignedBits(int val, int bits);
extern WORD GetBigWord(WORD w);
extern WORD GetBigWordRaw(BYTE *b);
extern int GetBigInt(int dw);
extern int GetBigIntRaw(BYTE *b);
extern void LittleBigSwap(void *in, int numBytes);
#define LITTLE_BIG_SWAP(a) LittleBigSwap(&a, sizeof(a))
size_t fseekread(__int64 ofs, void *dst, size_t elementSize, size_t count, FILE *file);
int freadint(FILE *file, bool bigEnd = false);
int fseekreadint(__int64 ofs, FILE *file, bool bigEnd = false);
short freadshort(FILE *file, bool bigEnd = false);
short fseekreadshort(__int64 ofs, FILE *file, bool bigEnd = false);

typedef enum
{
	NOESISTEX_UNKNOWN = 0,
	NOESISTEX_RGBA32,
	NOESISTEX_RGB24,
	NOESISTEX_DXT1,
	NOESISTEX_DXT3,
	NOESISTEX_DXT5,
	NUM_NOESIS_TEXTYPES
} noesisTexType_e;

typedef struct modelMatrix_s
{
	float				x1[3];
	float				x2[3];
	float				x3[3];
	float				o[3];
} modelMatrix_t;

typedef struct fourxMatrix_s
{
	float				c1[4];
	float				c2[4];
	float				c3[4];
	float				c4[4];
} fourxMatrix_t;

extern modelMatrix_t g_identityMatrix;
extern fourxMatrix_t g_identityMatrix4x4;

extern double g_dbPI;
extern float g_flPI;
extern float g_flDegToRad;
extern float g_flRadToDeg;

typedef struct modelVert_s
{
	float				x;
	float				y;
	float				z;
} modelVert_t;

typedef struct modelTan4_s
{
	float				v[4];
} modelTan4_t;

typedef struct modelTangent_s
{
	float				normal[3];
	float				tangent[3];
	float				bitangent[3];
} modelTangent_t;

typedef struct modelVertWInfo_s
{
	int					weightIndex;
	int					numWeights;
} modelVertWInfo_t;

typedef struct modelTexCoord_s
{
	float				u;
	float				v;
} modelTexCoord_t;

typedef struct modelTriFace_s
{
	WORD				a;
	WORD				b;
	WORD				c;
	WORD				flag;
} modelTriFace_t;

typedef struct modelTriNeighbors_s
{
	int					a;
	int					b;
	int					c;
} modelTriNeighbors_t;

typedef struct modelLongTri_s
{
	int					idx[3];
} modelLongTri_t;

typedef struct modelRGBA_s
{
	float				rgba[4];
} modelRGBA_t;

typedef struct newVertWeight_s
{
	int					boneIndex;
	float				weightFactor;
} newVertWeight_t;

//this shit is pretty messy. sorry about that.
typedef struct modelBone_s modelBone_t;
typedef struct modelBoneExData_s
{
	modelBone_t			*parent;
	modelBone_t			*next;
	modelMatrix_t		transMat;
	modelMatrix_t		relativeMat;
	modelMatrix_t		baseMat;
	modelMatrix_t		transWithLenMat;
	short				lastFrameAngles[3];

	//may eventually add extended data pointers, long name strings, etc.
	void				*resv[4];
} modelBoneExData_t;

//for feeding data back, only this structure and eData.parent matter.
//IT IS VERY IMPORTANT THAT EACH BONE'S 'name' CONTAINS A UNIQUE STRING.
typedef struct modelBone_s
{
	int					index;
	char				name[32];
	
	modelMatrix_t		mat;

	char				parentName[32];

	modelBoneExData_t	eData;
} modelBone_t;

typedef struct modelVMorphFr_s
{
	modelVert_t			*pos;
	modelVert_t			*nrm;
} modelVMorphFr_t;

//this exposes a chunk of my horrifying standard-type math library. i don't guarantee that any of these functions work, but most of them probably do.
typedef struct mathImpFn_s
{
	void (*Math_CalcPlaneEq)(float *x, float *y, float *z, float *planeEq);
	float (*Math_Max2)(float a, float b);
	float (*Math_Max3)(float a, float b, float c);
	float (*Math_Min2)(float a, float b);
	float (*Math_Min3)(float a, float b, float c);
	void (*Math_TransformPointByMatrix)(modelMatrix_t *matrix, float *in, float *out);
	void (*Math_TransformPointByMatrixNoTrans)(modelMatrix_t *matrix, float *in, float *out);
	void (*Math_MatrixInverse)(modelMatrix_t *in, modelMatrix_t *out);
	void (*Math_TransformPointByMatrix4x4)(float *matrix, float *in, float *out);
	void (*Math_MatrixInverse4x4)(float *mat, float *dst);
	float (*Math_MatRotDist)(modelMatrix_t *mat);
	float (*Math_VecRotDist)(float *v1, float *v2);
	void (*Math_MatToAngles)(float *angles, const modelMatrix_t *mat);
	void (*Math_AnglesToMat)(const float *incAngles, modelMatrix_t *mat);
	void (*Math_AngleVectors)(float *angles, float *forward, float *right, float *up);
	bool (*Math_MatrixIsSkewed)(modelMatrix_t *mat);
	void (*Math_OrthogonalizeMatrix)(modelMatrix_t *mat, bool keepScale, bool keepFlip, bool straightCross);
	void (*Math_LerpMatricesQ)(modelMatrix_t &preMat, modelMatrix_t &postMat, float lerpFrac, modelMatrix_t &outMat,
							   bool nonUniform);
	void (*Math_LerpMatrices)(modelMatrix_t &preMat, modelMatrix_t &postMat, float lerpFrac, modelMatrix_t &outMat,
							   bool nonUniform, bool orthogonalize);
	void (*Math_RotationMatrix)(float phi, int axis, modelMatrix_t *mat);
	void (*Math_MatrixMultiply)(modelMatrix_t *in, modelMatrix_t *in2, modelMatrix_t *out);
	void (*Math_4x4ToModelMat)(fourxMatrix_t *matFour, modelMatrix_t *mat);
	void (*Math_ModelMatToGL)(modelMatrix_t *mat, float *out);
	void (*Math_ModelMatFromGL)(modelMatrix_t *mat, float *in);
	void (*Math_TransposeMat)(modelMatrix_t *in, modelMatrix_t *out);
	void (*Math_TranslateMatrix)(modelMatrix_t *mat, float *v);
	void (*Math_RotateMatrix)(modelMatrix_t *mat, float ang, float x, float y, float z);
	void (*Math_MatrixMultiply4x4)(fourxMatrix_t *in, fourxMatrix_t *in2, fourxMatrix_t *out);
	void (*Math_RotationMatrix4x4)(float phi, int axis, fourxMatrix_t *mat);
	void (*Math_TranslateMatrix4x4)(fourxMatrix_t *mat, float *v);
	void (*Math_RotateMatrix4x4)(fourxMatrix_t *mat, float ang, float x, float y, float z);
	void (*Math_AxisForNormal)(float *normal, float *fwd, float *right, float *up);
	void (*Math_ExpandBounds)(float *baseMins, float *baseMaxs, float *mins, float *maxs);
	float (*Math_MaxExtent)(float *mins, float *maxs);
	bool (*Math_PointInOnBox)(float *point, float *boxMins, float *boxMaxs);
	bool (*Math_BoxesOverlap)(float *mins1, float *maxs1, float *mins2, float *maxs2);
	void (*Math_PlaneFromPoints)(float *p0, float *p1, float *p2,
					 float *plane);
	void (*Math_ConfinePointToBox)(float *mins, float *maxs, float *ptIn, float *ptOut);
	void (*Math_BuildBoxPlanes2D)(float *mins, float *maxs, float *planes);
	void (*Math_VecCopy)(float *a, float *out);
	void (*Math_VecSub)(float *a, float *b, float *out);
	void (*Math_VecSub2)(float *a, float *b, float *out);
	void (*Math_VecAdd)(float *a, float *b, float *out);
	void (*Math_VecScale)(float *a, float scale);
	void (*Math_VecScaleVec)(float *a, float *scale);
	float (*Math_VecNorm)(float *v);
	float (*Math_DotProduct)(const float *v1, const float *v2);
	void (*Math_CrossProduct)(const float *v1, const float *v2, float *cross);
	float (*Math_VecLen)(float *a);
	float (*Math_VecLenSq)(float *a);
	float (*Math_VecLen2)(float *a);
	void (*Math_VecMA)(float *veca, float scale, float *vecb, float *vecc);
	void (*Math_VecToAngles)(const float *value1, float *angles);
	void (*Math_ProjectOntoPlane)(const float *plane, const float *pos, float *out);
	bool (*Math_PointInTriPlanes)(float *v1, float *v2, float *v3, float *pos, float fudge);
	void (*Math_ConfinePointToTri)(float *verts[3], float *triPlane, float *point);
	void (*Math_GetTriEdgeFracs)(float *v1, float *v2, float *v3, float *pos, float *edgeFracs);
	float (*Math_ConstantLerp)(float y0, float y1, float amount);
	float (*Math_LinearLerp)(float y0, float y1, float frac);
	float (*Math_BilinearLerp)(float y0, float y1, float y2, float y3, float fracX, float fracY);
	float (*Math_TriLerp)(float y0, float y1, float y2, float fracX, float fracY, float fracZ);
	float (*Math_CubicLerp)(float y0, float y1, float y2, float y3, float frac);
	float (*Math_PlaneDist)(const float *pl, const float *p);
	float (*Math_GetFloat16)(WORD w);
	void (*Math_QuatToMat)(float *quat, modelMatrix_t *mat, bool compressed, bool transposed);
	void (*Math_MatToQuat)(modelMatrix_t *mat, float *quat, bool compressed);
	void (*Math_QuatSlerp)(float *from, float *to, float f, float *out);
	int (*Math_NextPow2)(int val);
	bool (*Math_CheckPointInTri)(float *v1, float *v2, float *v3, float *point);
	void (*Math_ExpandTriangle)(float *v1, float *v2, float *v3, float units, int components);
	float (*Math_GetMappedValue)(float perc, float *values, int numValues);
	void (*Math_RandSetSeed)(unsigned int seed);
	int (*Math_RandInt)(int low, int high);
	float (*Math_RandFloat)(float low, float high);
	int (*Math_RandIntOnSeed)(int low, int high, unsigned int &seed);
	float (*Math_RandFloatOnSeed)(float low, float high, unsigned int &seed);
	int (*Math_RandIntUnseeded)(int low, int high);
	float (*Math_RandFloatUnseeded)(float low, float high);

	//noesis 2.6 and later
	float (*Math_AngleMod)(float angle);
	float (*Math_BlendAngleLinear)(float in, float goal, float amount);
	void (*Math_RotateMatrixTP)(modelMatrix_t *mat, float ang, float x, float y, float z);

	//reserved, do not call.
	int					(*resvA)(void);
	int					(*resvB)(void);
	int					(*resvC)(void);
	int					(*resvD)(void);
	int					(*resvE)(void);
	int					(*resvF)(void);
	int					(*resvG)(void);
	int					(*resvH)(void);
} mathImpFn_t;

typedef struct textParser_s textParser_t;
typedef struct defineDict_s defineDict_t;
typedef struct textParser_s
{
	char				*groupName;
	char				*basePtr;
	char				*curPtr;
	int					lineNum;
	int					groupNum;
	textParser_t		*subGroup;
	bool				textOwner;
	const char			*includeKey;
	bool				isInclude;
	bool				unformattedText;
	bool				parseDoubleQuotes;

	bool				noGroupNames;
	bool				doNotStartGroups;
	bool				resbA;
	bool				resbB;
	defineDict_t		*defines;
	int					nestedGroups;

	void				*resv[5];
} textParser_t;
#define MAX_TOKEN_SIZE		1024
typedef struct parseToken_s
{
	const char			*groupName;
	char				text[MAX_TOKEN_SIZE];
	int					lineNum;
	int					groupNum;
	int					nestedGroups;

	void				*resv[7];
} parseToken_t;

typedef enum
{
	NOEFSMODE_READBINARY = 0,
	NOEFSMODE_WRITEBINARY,
	NOEFSMODE_READWRITEBINARY
} noeFSMode_e;

#define NTEXFLAG_ISNORMALMAP			(1<<0)
#define NTEXFLAG_SEGMENTED				(1<<1)

#define NMATFLAG_NMAPSWAPRA				(1<<0) //swap red and alpha channels when displaying normal map
#define NMATFLAG_TWOSIDED				(1<<1) //no face culling

typedef struct noesisModel_s noesisModel_t;

typedef struct noesisASeq_s
{
	char				*name;
	int					startFrame;
	int					endFrame;
	float				frameRate;

	int					resv[8];
} noesisASeq_t;

typedef struct noesisASeqList_s
{
	noesisASeq_t		*s;
	int					numSeq;

	int					resv[8];
} noesisASeqList_t;

#define NANIMFLAG_FORCENAMEMATCH			(1<<0)	//when set, even if the animation's bone count matches the model's, Noesis will still attempt to use bone names to match bones instead of indices
#define NANIMFLAG_INVALIDHIERARCHY			(1<<1)	//when set, the animation data's hierarchy will be overwritten with that of any available model's
typedef struct noesisAnim_s
{
	char				*filename;
	BYTE				*data;
	int					dataLen;
	bool				shouldFreeData;
	bool				copied;

	noesisModel_t		*mdlPtr;
	noesisASeqList_t	*aseq;
	modelBone_t			*bones;
	int					numBones;
	int					flags;
	int					resv[7];
} noesisAnim_t;
typedef struct noesisTexFr_s
{
	int				ofsX;
	int				ofsY;
	int				frameIdx;
	int				viewType;
	float			rad; //i have no idea why you'd want this, but it's preserved mainly for quake spr's at the moment
	int				resv[16];
} noesisTexFr_t; //new in 3.31
typedef struct noesisTex_s
{
	char			*filename;
	int				w;
	int				h;
	int				type;
	BYTE			*data;
	int				dataLen;
	int				gltex;
	int				globalIdx; //used optionally by some modules
	int				flags;
	bool			shouldFreeData;

	int				refCount; //do not modify refCount. it's managed internally.
	noesisTexFr_t	*frameInfo; //new in 3.31 - allocate with Noesis_TexFrameInfoAlloc if you want to use it
	int				resv[7]; //THESE VALUES MUST BE 0 (this is done by Noesis_TextureAlloc)
} noesisTex_t;

typedef struct noesisExtTexRef_s
{
	char			*diffuse;
	char			*normal;
	char			*specular;
	char			*opacity;

	int				reserved[32];
} noesisExtTexRef_t;
/*
Noesis blends:
0 - "None"
1 - "GL_ZERO"
2 - "GL_ONE"
3 - "GL_SRC_COLOR"
4 - "GL_ONE_MINUS_SRC_COLOR"
5 - "GL_SRC_ALPHA"
6 - "GL_ONE_MINUS_SRC_ALPHA"
7 - "GL_DST_ALPHA"
8 - "GL_ONE_MINUS_DST_ALPHA"
9 - "GL_DST_COLOR"
10 - "GL_ONE_MINUS_DST_COLOR"
11 - "GL_SRC_ALPHA_SATURATE"
*/
typedef struct noesisMaterial_s
{
	char			*name;
	bool			skipRender;
	float			diffuse[4];
	float			specular[4];
	bool			noDefaultBlend;
	int				texIdx;
	int				extTex; //external texture override

	int				blendSrc;
	int				blendDst;
	float			alphaTest;
	bool			noLighting;

	int				normalTexIdx;
	int				specularTexIdx;
	int				transTexIdx;
	int				transFragProg;

	int				flags;

	int				refCount; //do not modify refCount. it's managed internally.
	noesisExtTexRef_t	*extRefs;
	int				resv[7];
} noesisMaterial_t;

typedef struct noesisMatData_s
{
	noesisTex_t			*textures;
	int					numTextures;

	noesisMaterial_t	*materials;
	int					numMaterials;

	int					refCount; //do not modify refCount. it's managed internally.
	int					resv[8];
} noesisMatData_t;

typedef struct noesisTexRef_s
{
	noesisTex_t				*t;
	int						loadedIdx;
	char					*loadedName;
	int						pageX;
	int						pageY;
	int						origIdx;
} noesisTexRef_t;

class RichBitStream;

typedef enum
{
	RPGEO_NONE = 0,
	RPGEO_POINTS,
	RPGEO_TRIANGLE,
	RPGEO_TRIANGLE_STRIP,
	RPGEO_QUAD,
	RPGEO_POLYGON,
	RPGEO_TRIANGLE_FAN,
	RPGEO_QUAD_STRIP,
	RPGEO_TRIANGLE_STRIP_FLIPPED,
	NUM_RPGEO_TYPES
} rpgeoPrimType_e;

typedef enum
{
	RPGEODATA_FLOAT = 0,
	RPGEODATA_INT,
	RPGEODATA_UINT,
	RPGEODATA_SHORT,
	RPGEODATA_USHORT,
	RPGEODATA_HALFFLOAT,
	RPGEODATA_DOUBLE,
	RPGEODATA_BYTE,
	RPGEODATA_UBYTE,
	NUM_RPGEO_DATATYPES
} rpgeoDataType_e;

#define NMSHAREDFL_WANTNEIGHBORS				(1<<0)
#define NMSHAREDFL_WANTGLOBALARRAY				(1<<1)
#define NMSHAREDFL_WANTTANGENTS					(1<<2)
#define NMSHAREDFL_FLATWEIGHTS					(1<<3)
#define NMSHAREDFL_FLATWEIGHTS_FORCE4			(1<<4) //forces 4 weights per vertex, whether actual source weights are more or less
#define NMSHAREDFL_REVERSEWINDING				(1<<5) //reverses the face winding on the model
#define NMSHAREDFL_WANTTANGENTS4				(1<<6) //requests 4-vector tangents with bitangent sign stored in w
#define NMSHAREDFL_WANTTANGENTS4R				(1<<7) //same as above with reverse winding on tangent calculations
#define NMSHAREDFL_UNIQUEVERTS					(1<<8) //produces a unique vertex for every triangle point

typedef struct sharedPAnimParm_s
{
	int						boneIdx;
	float					angAmt;
	int						axis;
	float					timeScale;

	int						resv[32]; //this is mainly a debugging/testing feature anyway, might as well bloat it.
} sharedPAnimParm_t;

typedef enum
{
	SHAREDSTRIP_LIST,
	SHAREDSTRIP_STRIP,
	SHAREDSTRIP_NUM
} sharedStripType_e;
typedef struct sharedStripList_s
{
	sharedStripType_e		type;
	WORD					*idx;
	int						numIdx;
} sharedStripList_t;

typedef struct sharedMesh_s
{
	int							numVerts;
	modelVert_t					*verts;
	modelVert_t					*normals;
	modelTangent_t				*tangents;
	modelTexCoord_t				*uvs;
	modelVertWInfo_t			*vertWInfo;
	modelRGBA_t					*colors;

	modelTexCoord_t				*lmCoords;
	modelTangent_t				*lmTangents;
	int							lmIndex;

	int							numWeights;
	newVertWeight_t				*weights;

	modelVMorphFr_t				*morphFrames;
	int							numMorphFrames;

	int							numTris;
	modelTriFace_t				*tris;
	modelTriNeighbors_t			*triNeighbors;

	char						*name;
	char						*skinName;

	//only filled in if requested with NMSHAREDFL_WANTGLOBALARRAY
	int							firstVert;
	int							firstTri;

	//only filled in if requested with NMSHAREDFL_FLATWEIGHTS
	int							*flatBoneIdx;
	float						*flatBoneWgt;
	int							numWeightsPerVert;

	//transformed arrays are only filled in by rpgTransformModel
	modelVert_t					*transVerts;
	modelVert_t					*transNormals;

	void						*internalMesh; //new in Noesis 2.1

	int							*texRefIdx; //new in Noesis 2.2

	int							materialIdx; //new in Noesis 2.95 - is -1 if material is not valid. otherwise an index into the model's matDat material list.

	modelTan4_t					*tan4;

	void						*resv[12];
} sharedMesh_t;
typedef struct sharedLightData_s
{
	int						numLightmaps;
	int						lightmapSize;
	BYTE					*lightmapData;
	BYTE					*lightmapVectors;

	//plan to provide a variety of lightgrid data here
	void					*resv[128];
} sharedLightData_t;
typedef struct sharedVMap_s
{
	int							meshIdx;
	int							vertIdx;
} sharedVMap_t;
typedef struct sharedModel_s
{
	sharedMesh_t				*meshes;
	int							numMeshes;

	modelBone_t					*bones;
	int							numBones;

	noesisMatData_t				*matData;
	noesisAnim_t				*animData;

	sharedLightData_t			*lightData;

	//abs array data is zeroed out unless you request it with NMSHAREDFL_WANTGLOBALARRAY
	int							numAbsTris;
	modelLongTri_t				*absTris;
	modelTriNeighbors_t			*absTriNeighbors;
	int							numAbsVerts;
	sharedVMap_t				*absVertMap;

	void						*internalMdl; //new in Noesis 2.2
	void						*resv[15];
} sharedModel_t;

typedef struct noeStringPool_s noeStringPool_t;

typedef void (*NOEXFUNCTION)();

typedef struct noeRAPI_s
{
	void				*(*Noesis_PooledAlloc)(size_t size); //pooled allocations are automatically cleared once the preview/conversion is closed/reset
	char				*(*Noesis_PooledString)(char *str);
	void				*(*Noesis_UnpooledAlloc)(size_t size); //you must free up unpooled allocations yourself
	void				(*Noesis_UnpooledFree)(void *ptr);

	noeStringPool_t		*(*Noesis_CreateStrPool)(void);
	void				(*Noesis_DestroyStrPool)(noeStringPool_t *pool);
	int					(*Noesis_StrPoolGetOfs)(noeStringPool_t *pool, char *str);
	int					(*Noesis_StrPoolSize)(noeStringPool_t *pool);
	BYTE				*(*Noesis_StrPoolMem)(noeStringPool_t *pool);

	NOEXFUNCTION		(*Noesis_GetExtProc)(char *extName);
	char				*(*Noesis_GetExtList)(void);

	BYTE				*(*Noesis_ReadFile)(const char *filename, int *sizeOut); //you must free the pointer returned by Noesis_ReadFile with Noesis_UnpooledFree! (unless it's NULL)
	bool				(*Noesis_WriteFile)(const char *filename, void *data, int dataSize);
	bool				(*Noesis_WriteFileMakePath)(const char *filename, void *data, int dataSize);

	BYTE				*(*Noesis_LoadPairedFile)(char *fileDescr, char *fileExt, int &outLen, char *outPath); //creates an actual "open dialog" prompt for the user
	char				*(*Noesis_GetOutputName)(void);
	char				*(*Noesis_GetInputName)(void);
	char				*(*Noesis_GetLastCheckedName)(void);
	bool				(*Noesis_CheckFileExt)(const char *filename, const char *ext);
	void				(*Noesis_GetLocalFileName)(char *dst, char *src);
	void				(*Noesis_GetExtensionlessName)(char *dst, char *src);
	void				(*Noesis_GetDirForFilePath)(char *dst, char *src);

	noesisTex_t			*(*Noesis_TextureAlloc)(char *filename, int w, int h, BYTE *data, int type);
	noesisMaterial_t	*(*Noesis_GetMaterialList)(int numMaterials, bool texByIndex);
	noesisAnim_t		*(*Noesis_AnimAlloc)(char *filename, BYTE *data, int dataLen);
	noesisMatData_t		*(*Noesis_GetMatData)(noesisMaterial_t *mats, int numMats, noesisTex_t *tex, int numTex);
	noesisMatData_t		*(*Noesis_GetMatDataFromLists)(CArrayList<noesisMaterial_t *> &mats, CArrayList<noesisTex_t *> &tex);

	bool				(*Noesis_HasActiveGeometry)(void);
	int					(*Noesis_GetActiveType)(void);

	//RichPGeo exposure
	void				*(*rpgCreateContext)(void); //create a new context
	void				(*rpgDestroyContext)(void *ctx); //always do this after you're done with a context
	void				(*rpgSetActiveContext)(void *ctx); //note that rpgCreateContext will automatically set the newly-created context as the active one

	void				(*rpgReset)(void);
	void				(*rpgSetMaterial)(char *matName);
	void				(*rpgSetMaterialIndex)(int index);
	void				(*rpgClearMaterials)(void);
	void				(*rpgSetName)(char *objName);
	void				(*rpgClearNames)(void);
	void				(*rpgClearMorphs)(void);
	void				(*rpgSetTransform)(modelMatrix_t *mat); //transforms all vertices/normals
	void				(*rpgSetPosScaleBias)(float *scale, float *bias);
	void				(*rpgSetUVScaleBias)(float *scale, float *bias);
	void				(*rpgSetBoneMap)(int *boneRefMap); //use this for models which use draw-relative bone indices
	void				(*rpgSetEndian)(bool isBig);
	void				(*rpgSetTriWinding)(bool backward);

	void				(*rpgBegin)(rpgeoPrimType_e type);
	void				(*rpgEnd)(void);

	void				(*rpgDataToInt)(int *dst, void *src, int numElem, rpgeoDataType_e srcType, bool bigEndian);
	void				(*rpgDataToFloat)(float *dst, void *src, int numElem, rpgeoDataType_e srcType, bool bigEndian, bool scaleBias);

	void				(*rpgVertex3f)(float *pos);
	void				(*rpgVertexX)(void *data, rpgeoDataType_e dataType, int numComponents);
	void				(*rpgVertex3s)(short *pos);
	void				(*rpgVertex3hf)(WORD *pos);
	void				(*rpgVertNormal3f)(float *nrm);
	void				(*rpgVertNormalX)(void *data, rpgeoDataType_e dataType, int numComponents);
	void				(*rpgVertNormal3us)(WORD *nrm);
	void				(*rpgVertNormal3s)(short *nrm);
	void				(*rpgVertNormal3hf)(WORD *nrm);
	void				(*rpgVertUV2f)(float *uv, int idx);
	void				(*rpgVertUVX)(void *data, rpgeoDataType_e dataType, int numComponents, int idx);
	void				(*rpgVertUV2us)(WORD *uv, int idx);
	void				(*rpgVertUV2s)(short *uv, int idx);
	void				(*rpgVertUV2hf)(WORD *uv, int idx);
	void				(*rpgVertColor4f)(float *clr);
	void				(*rpgVertColorX)(void *data, rpgeoDataType_e dataType, int numComponents);
	void				(*rpgVertColor4us)(WORD *clr);
	void				(*rpgVertColor4ub)(BYTE *clr);
	void				(*rpgVertColor3f)(float *clr);
	void				(*rpgVertColor3us)(WORD *clr);
	void				(*rpgVertColor3ub)(BYTE *clr);
	void				(*rpgVertBoneIndexI)(int *idx, int num);
	void				(*rpgVertBoneIndexX)(void *data, rpgeoDataType_e dataType, int num);
	void				(*rpgVertBoneIndexUB)(BYTE *idx, int num);
	void				(*rpgVertBoneIndexUS)(WORD *idx, int num);
	void				(*rpgVertBoneIndexUI)(DWORD *idx, int num);
	void				(*rpgVertBoneIndexB)(char *idx, int num);
	void				(*rpgVertBoneIndexS)(short *idx, int num);
	void				(*rpgVertBoneWeightF)(float *wgt, int num);
	void				(*rpgVertBoneWeightX)(void *data, rpgeoDataType_e dataType, int num);
	void				(*rpgVertBoneWeightHF)(WORD *wgt, int num);
	void				(*rpgVertBoneWeightUS)(WORD *wgt, int num);
	void				(*rpgVertBoneWeightUB)(BYTE *wgt, int num);
	void				(*rpgVertMorphIndex)(int idx);

	void				(*rpgBindPositionBuffer)(void *data, rpgeoDataType_e dataType, int stride);
	void				(*rpgBindNormalBuffer)(void *data, rpgeoDataType_e dataType, int stride);
	void				(*rpgBindUV1Buffer)(void *data, rpgeoDataType_e dataType, int stride);
	void				(*rpgBindUV2Buffer)(void *data, rpgeoDataType_e dataType, int stride);
	void				(*rpgBindColorBuffer)(void *data, rpgeoDataType_e dataType, int stride, int numChannels);
	void				(*rpgBindBoneIndexBuffer)(void *data, rpgeoDataType_e dataType, int stride, int numWeightsPerVert);
	void				(*rpgBindBoneWeightBuffer)(void *data, rpgeoDataType_e dataType, int stride, int numWeightsPerVert);
	void				(*rpgClearBufferBinds)(void);
	//morph target functionality
	void				(*rpgFeedMorphTargetPositions)(void *data, rpgeoDataType_e dataType, int stride);
	void				(*rpgFeedMorphTargetNormals)(void *data, rpgeoDataType_e dataType, int stride);
	//do not call CommitMorphFrame unless you are sure data fed by FeedMorphX will remain valid
	void				(*rpgCommitMorphFrame)(int numVerts);
	//call once an entire morph set has been committed
	void				(*rpgCommitMorphFrameSet)(void);

	//CommitTriangles should only be called once all of the appropriate vertex buffers are bound
	void				(*rpgCommitTriangles)(void *idxData, rpgeoDataType_e dataType, int numIdx, rpgeoPrimType_e primType, bool usePlotMap);

	void				(*rpgOptimize)(void); //optimizes lists to remove duplicate vertices, sorts triangles by material, etc.
	noesisModel_t		*(*rpgConstructModel)(void); //constructs the model from all given input
	bool				(*rpgFromModel)(noesisModel_t *mdl); //constructs the RichPGeo's contents from a model (returns false if it failed)

	void				(*rpgSetExData_Bones)(modelBone_t *bones, int numBones);
	void				(*rpgSetExData_Materials)(noesisMatData_t *md);
	void				(*rpgSetExData_Anims)(noesisAnim_t *anims);

	//this interface exists in order to allow the noesis model structures to change freely and drastically without breaking plugin compatibility.
	//accessing data directly around a noesisModel_t would be extremely unwise, and virtually guarantees future versions of noesis will break your plugin.
	//additionally, you needn't worry about freeing/destroying shared model handles, as they're pool-allocated.
	sharedModel_t		*(*rpgGetSharedModel)(noesisModel_t *mdl, int sharedMdlFlags);

	//creates transformed vertex arrays using the provided animation matrices
	void				(*rpgTransformModel)(sharedModel_t *pmdl, modelMatrix_t *animMats, int frame);

	//grabs various extents of the model, using transformed positions if available. any input may be null if it's not desired.
	void				(*rpgGetModelExtents)(sharedModel_t *pmdl, float *mins, float *maxs, float *rad, float *xyRad, bool radFromCenter);

	//extracts a list of parent-relative matrices from an animation, in the format of ((matrix for each bone) for each frame).
	//if pooled is false, non-null returned pointer must be freed, via Noesis_UnpooledFree.
	modelMatrix_t		*(*rpgMatsFromAnim)(noesisAnim_t *anim, int &numFrames, float &frameRate, int *numBones, bool pooled);

	//rpgAnimFromBonesAndMats expects a list of matrices, ordered as ((matrix for each bone) for each frame)
	//animation matrices should be fed as parent-relative. data does not need to be freed. (it's pooled)
	//IMPORTANT NOTE!!!!!!!
	//you should use rpgAnimFromBonesAndMatsFinish instead if you are passing the final data for export (which is going to be most of the time)
	//only use this function instead of rpgAnimFromBonesAndMatsFinish when you are going to be ripping the data back out for your own local purposes.
	noesisAnim_t		*(*rpgAnimFromBonesAndMats)(modelBone_t *bones, int numBones, modelMatrix_t *animMats, int numFrames, float frameRate);

	void				(*rpgMultiplyBones)(modelBone_t *bones, int numBones);

	void				(*SetPreviewAnimSpeed)(float animSpeed);
	void				(*SetPreviewAngOfs)(float *mdlAngOfs);

	int					(*LogOutput)(const char *fmt, ...);

	//ADDED IN NOESIS 2.1
	//performs rpgAnimFromBonesAndMats, and adds additional process-global rotations, translations, etc. to the animation matrices
	noesisAnim_t		*(*rpgAnimFromBonesAndMatsFinish)(modelBone_t *bones, int numBones, modelMatrix_t *animMats, int numFrames, float frameRate);

	//ADDED IN NOESIS 2.2
	//returns a value string for an option, or NULL if the option is not available.
	char							*(*Noesis_GetOption)(char *optionName);
	//takes a source rgba32 image, a destination 8bpp (palette index) of the same dimensions, and a 256-entry rgba32 (1024 bytes) palette.
	//fills in the contents of dstPix appropriately, using the provided palette to match colors from the rgba32 image.
	void							(*Noesis_ApplyPaletteRGBA)(BYTE *rgba, int w, int h, BYTE *dstPix, BYTE *pal);
	//same as Noesis_ApplyPaletteRGBA, except the dstPal is filled in with this operation. if firstClear is set, the first entry in the palette
	//is set to (0,0,0,0) (black, no alpha)
	void							(*Noesis_PalettizeRGBA)(BYTE *rgba, int w, int h, BYTE *dstPix, BYTE *dstPal, bool firstClear);
	//sets and gets extra animation data, to be checked/used by formats that wish to compile animation data into output models
	void							(*Noesis_SetExtraAnimData)(BYTE *animData, int animDataSize);
	BYTE							*(*Noesis_GetExtraAnimData)(int &animDataSize);
	//loads model textures into a single list, including externally-referenced textures. note that this may change the address of material data.
	CArrayList<noesisTexRef_t>		&(*Noesis_LoadTexturesForModel)(sharedModel_t *pmdl);
	//creates a single RGBA32 texture page from a list of textures, filling pageWidth and pageHeight with the end result's dimensions.
	//after calling this function, the texref's pageX/Y values can be used to locate the texture within the page.
	//non-null returned pointer must be freed with Noesis_UnpooledFree.
	BYTE							*(*Noesis_CreateRefImagePage)(CArrayList<noesisTexRef_t> &trefs, int &pageWidth, int &pageHeight);
	//performs a bilinear image resize on rgba32 image data
	void							(*Noesis_ResampleImageBilinear)(unsigned char *src, int srcW, int srcH, unsigned char *dst, int dstW, int dstH);
	//generates a list of triangle strip indices from a mesh triangle list (stripOut pointer is pool-allocated)
	bool							(*rpgGenerateStripIndices)(modelTriFace_t *tris, int numTris, WORD **stripOut, int &stripIdxNum);
	//generates a list of triangle strips, each of which can contain indices in the form of triangle lists or strips. (unless doStitch is true, which results in a single list of strip indices)
	//all data provided by this function is pool-allocated.
	bool							(*rpgGenerateStripLists)(const WORD *idx, int numIdx, sharedStripList_t **stripOut, int &stripNum, bool doStitch);
	//text parsing functions
	textParser_t					*(*Parse_InitParser)(char *rawText);
	textParser_t					*(*Parse_InitParserFromFile)(const char *filename);
	bool							(*Parse_WhiteSpace)(char chr);
	void							(*Parse_FreeParser)(textParser_t *parser);
	void							(*Parse_EnableInclude)(textParser_t *parser, const char *includeKey);
	bool							(*Parse_GetNextToken)(textParser_t *parser, parseToken_t *parseToken);
	//check if a file exists
	bool							(*Noesis_FileExists)(const char *filename);

	//ADDED IN NOESIS 2.3
	//allows you to specify an array of animation data
	void				(*rpgSetExData_AnimsNum)(noesisAnim_t *anims, int animsNum);
	//creates a contiguous block of animations from a list (pool-allocated)
	noesisAnim_t		*(*Noesis_AnimsFromList)(CArrayList<noesisAnim_t *> &animList, int &animsOut);
	//creates a contiguous block of models from a list (pool-allocated)
	noesisModel_t		*(*Noesis_ModelsFromList)(CArrayList<noesisModel_t *> &modelList, int &modelsOut);
	//procedurally generates an animation, rotating given bone(s) along given axis(es). useful for testing your bone weights.
	noesisAnim_t		*(*rpgCreateProceduralAnim)(modelBone_t *bones, int numBones, sharedPAnimParm_t *parms, int numParms, int numFrames);
	//provides a unified interface for pool-allocating bones
	modelBone_t			*(*Noesis_AllocBones)(int numBones);
	//allocates a placeholder texture
	noesisTex_t			*(*Noesis_AllocPlaceholderTex)(char *name, int width, int height, bool normalMap);
	//performs a variety of normal-correction operations on a single 4-byte rgba32 pixel
	void				(*Noesis_SwizzleNormalPix)(BYTE *p, bool swapAR, bool deriveB, bool isSigned);
	//untiles raw pixel data
	void				(*Noesis_UntileImageRAW)(BYTE *dst, BYTE *src, int dstSize, int imgW, int imgH, int bytesPerPix);
	//untiles dxt-encoded pixel data
	void				(*Noesis_UntileImageDXT)(BYTE *dst, BYTE *src, int dstSize, int imgW, int imgH, int blockSize);

	//ADDED IN NOESIS 2.5
	//decompression functions return < 0 on failure.
	//zlib inflate (return 0 means success)
	int					(*Decomp_Inflate)(BYTE *srcBuf, BYTE *dstBuf, DWORD srcSize, DWORD dstSize);
	//puff
	int					(*Decomp_Puff)(BYTE *srcBuf, BYTE *dstBuf, DWORD srcSize, DWORD *dstSize);
	//blast
	int					(*Decomp_Blast)(BYTE *srcBuf, BYTE *dstBuf, DWORD srcSize, DWORD *dstSize);
	//lzs used in ff7/ff8
	int					(*Decomp_LZS01)(BYTE *srcBuf, BYTE *dstBuf, DWORD srcSize, DWORD dstSize);
	//used in various capcom games, mainly
	int					(*Decomp_FPK)(BYTE *srcBuf, BYTE *dstBuf, DWORD srcSize, DWORD dstSize);
	//lzma
	int					(*Decomp_LZMA)(BYTE *srcBuf, BYTE *dstBuf, DWORD srcSize, DWORD dstSize, BYTE *props, int propsSize);
	//lzo (used in silent hill homecoming, maybe others)
	int					(*Decomp_LZO)(BYTE *srcBuf, BYTE *dstBuf, DWORD srcSize, DWORD dstSize);
	//lzo (used in metroid prime 2, maybe others)
	int					(*Decomp_LZO2)(BYTE *srcBuf, BYTE *dstBuf, DWORD srcSize, DWORD dstSize);
	//zlib deflate, returns compressed size
	int					(*Compress_Deflate)(BYTE *srcBuf, BYTE *dstBuf, DWORD srcSize, DWORD dstSize, int level);
	//compress lzma, recommended settings: level=9, dictSize=(1<<16), lc=3, lp=0, pb=2, fb=32, returns compressed size
	int					(*Compress_LZMA)(BYTE *srcBuf, BYTE *dstBuf, DWORD srcSize, DWORD dstSize, BYTE *props, int *propsSize, int level, int dictSize, int lc, int lp, int pb, int fb);
	//converts dxt data to rgba32. dxtFmt is the FOURCC code for the pixel data. you must free the non-null return pointer with Noesis_UnpooledFree.
	//this function also handles FOURCC_ATI2. (special normal compression mode)
	BYTE				*(*Noesis_ConvertDXT)(int w, int h, BYTE *data, DWORD dxtFmt);
	//untwiddles data which has been twiddled for the psp gpu. pixDataSize (in bytes) can be larger than width*height*bpp would dictate, to indicate padding.
	bool				(*Noesis_UntwiddlePSP)(BYTE *pixData, int pixDataSize, int width, int height, int bitsPerPixel);
	//writes an exported file entry from an archive. filename should be the archive-relative path, NOT the absolute path.
	bool				(*Noesis_ExportArchiveFile)(char *filename, BYTE *buf, int bufSize);
	//opens a FILE stream in binary write mode, using the same path system as the above function. you are responsible for closing the file.
	//DO NOT USE THIS FUNCTION ANYMORE - use Noesis_ExportArchiveFileOpen instead
	FILE				*(*Noesis_ExportArchiveFileOpenDEPRECATED)(char *filename, FILE *(*openfunc)(const char *filename, const char *mode));

	//new in Noesis 2.7
	//get a bone list along with other anim data, which describes hierarchy and anim bones
	modelMatrix_t		*(*rpgMatsAndInfoFromAnim)(noesisAnim_t *anim, int &numFrames, float &frameRate, int *numBones, modelBone_t **boneInfo, bool pooled);
	//final output point for export of animation data
	bool				(*Noesis_WriteAnimFile)(char *animName, char *extension, BYTE *buf, int len);
	//allocate animation sequence data
	noesisASeqList_t	*(*Noesis_AnimSequencesAlloc)(int numSequences, int numFrames);
	//allocate a model container
	noesisModel_t		*(*Noesis_AllocModelContainer)(noesisMatData_t *matData, noesisAnim_t *animData, int animDataNum);
	//generic lzss decompression. an example for schemes commonly seen on the wii would be
	//Decomp_LZSSGeneric(srcBuf, dstBuf, srcSize, dstSize, 8, 4, 12, false, 3, -1, true, false, true);
	int					(*Decomp_LZSSGeneric)(BYTE *srcBuf, BYTE *dstBuf, DWORD srcSize, DWORD dstSize,
											int ctrlBits, int lenBits, int ofsBits, bool lenFirst, int addLen, int addOfs, bool revCtrlBits, bool nzLiteral, bool bigRefBits);
	//do a qsort operation on a bone list. returns pointer to a mapping of which bone went where. map is pool-allocated and does not need to be freed.
	//this function also re-associates parents correctly within the bones list. if postHieSort is true, final list will also be sorted by hierarchy.
	int					*(*Noesis_QSortBones)(modelBone_t *bones, int numBones, int (*compareFunc)(const modelBone_t *a, const modelBone_t *b), bool postHieSort);
	//pool-allocates a full copy of the bones list, correctly adjusts parent, etc. pointers
	modelBone_t			*(*Noesis_CopyBones)(modelBone_t *bones, int numBones);
	//uses hashing to quickly create a list of unique elements. (using memory comparison)
	//returned pointer is to a list of unique elements, and must be freed with Noesis_UnpooledFree.
	//numElems will be modified to contain the output number of unique elments.
	//elemMap should be NULL, or an array of numElems ints, which will contain the mapped element indices from elemData into the returned array.
	void				*(*Noesis_GetUniqueElements)(void *elemData, int elemStride, int elemSize, int &numElems, int *elemMap);

	//new in Noesis 2.95
	//allocate external texture reference memory, which you may attach to a noesisMaterial_t.
	//all memory (including string copies passed back on the object) is pooled and does not need to be freed.
	//any and/or all arguments may be null.
	noesisExtTexRef_t	*(*Noesis_AllocTexRefs)(char *diffuse, char *normal, char *specular, char *opacity);

	//sets preview options. current options available are:
	//key									value(s)
	//----------------------------------------------
	//"drawAllModels"						"0"/"1" (toggles drawing all models at once in preview mode by default)
	//"noTextureLoad"						"0"/"1" (toggles auto-loading of textures for previewed model based on tex/mat names)
	//"setAnimPlay"							"0"/"1" (if 1, auto-starts animation in preview)
	void				(*SetPreviewOption)(char *optName, char *optVal);

	//new in Noesis 2.97
	wchar_t				*(*Noesis_GetOutputNameW)(void);
	wchar_t				*(*Noesis_GetInputNameW)(void);
	wchar_t				*(*Noesis_GetLastCheckedNameW)(void);
	bool				(*Noesis_CheckFileExtW)(const wchar_t *filename, const wchar_t *ext);
	void				(*Noesis_GetLocalFileNameW)(wchar_t *dst, wchar_t *src);
	void				(*Noesis_GetExtensionlessNameW)(wchar_t *dst, wchar_t *src);
	void				(*Noesis_GetDirForFilePathW)(wchar_t *dst, wchar_t *src);
	//sets anim data for a model. this call is only necessary to set animations for a model if rpgSetExData_Anims was not used before its creation.
	void				(*Noesis_SetModelAnims)(noesisModel_t *mdl, noesisAnim_t *anims, int numAnims);
	//sets material data for a model. this call is only necessary to set materials for a model if rpgSetExData_Materials was not used before its creation.
	void				(*Noesis_SetModelMaterials)(noesisModel_t *mdl, noesisMatData_t *md);
	BYTE				*(*Noesis_LoadPairedFileW)(wchar_t *fileDescr, wchar_t *fileExt, int &outLen, wchar_t *outPath);
	BYTE				*(*Noesis_ReadFileW)(const wchar_t *filename, int *sizeOut); //you must free the pointer returned by Noesis_ReadFile with Noesis_UnpooledFree! (unless it's NULL)
	bool				(*Noesis_WriteFileW)(const wchar_t *filename, void *data, int dataSize);
	bool				(*Noesis_WriteFileMakePathW)(const wchar_t *filename, void *data, int dataSize);

	//new in Noesis 2.98
	//checks the properties of a material against others in the list, and returns the index of a material that matches if one already exists. if none exists, returns index of the new material in the list.
	//if the includeName argument is true, the names of the materials will also be compared in checking that they are identical.
	int					(*Noesis_FindOrAddMaterial)(CArrayList<noesisMaterial_t *> &matList, noesisMaterial_t *mat, bool includeName);
	//if enabled is non-0, the model will have its triangles sorted by material and distance from the viewer before being drawn.
	//enabled=1 means that triangles will be sorted by distance of mesh before distance of triangles, generally keeping draw batching intact.
	//enabled=2 means that triangles will be sorted purely by their own distance. however, this can interrupt draw batching, creating thousands of draw calls and destroying performance.
	void				(*Noesis_SetModelTriSort)(noesisModel_t *mdl, int enabled);

	//new in Noesis 2.981
	noesisModel_t		*(*rpgConstructModelAndSort)(void); //performs rpgConstructModel with a triangle sort

	//new in Noesis 2.99
	//performs an in-place ps2 untwiddling. bpp (bits per pixel) must be 4 or 8.
	void				(*Noesis_UntwiddlePS2)(BYTE *pix, int w, int h, int bpp);

	//new in Noesis 3.0
	//creates a single animation with a sequence list from all of the combined animations fed in.
	//all animations must have the same bone count, or the function will fail and return NULL.
	noesisAnim_t		*(*Noesis_AnimFromAnims)(noesisAnim_t *anims, int numAnims);
	//identical to Noesis_AnimFromAnims, but accepts a pointer list as input, and returns NULL if any entry in the list is NULL.
	noesisAnim_t		*(*Noesis_AnimFromAnimsList)(CArrayList<noesisAnim_t *> &anims, int numAnims);

	//new in Noesis 3.1
	//opens a file stream handle
	void				*(*Noesis_FSOpen)(const wchar_t *filename, noeFSMode_e mode);
	//closes a file stream handle
	void				(*Noesis_FSClose)(void *file);
	//get file size
	__int64				(*Noesis_FSGetSize)(void *file);
	//seek
	void				(*Noesis_FSSeek)(void *file, __int64 pos, bool seekRelative);
	//get position
	__int64				(*Noesis_FSTell)(void *file);
	//eof?
	bool				(*Noesis_FSEOF)(void *file);
	//reads from a file stream handle
	__int64				(*Noesis_FSRead)(void *dstBuf, __int64 size, void *file);
	//write to a file stream handle
	__int64				(*Noesis_FSWrite)(void *srcBuf, __int64 size, void *file);
	//guess the extension of a file based on its contents (currently fairly limited in possible results, will be expanding in the future)
	char				*(*Noesis_GuessFileExt)(BYTE *data, int dataLen);

	//new in Noesis 3.15
	//generates smooth normals for the rpgeo context. should be called after all geometry has been added, but before rpgConstructModel.
	//resv MUST BE NULL. (may be utilized in future updates)
	void				(*rpgSmoothNormals)(void *resv);

	//new in Noesis 3.17
	//pixStride is expected to be 3 for rgb888 or 4 for rgba8888 data. desiredColors can be any number.
	//if useAlpha is true (and pixStride is 4), the alpha channel will be considered in the process.
	//the returned buffer will be in rgba8888 format (regardless of pixStride), and must be freed by Noesis_UnpooledFree.
	BYTE				*(*Image_GetMedianCut)(BYTE *pix, int pixStride, int w, int h, int desiredColors, bool useAlpha);

	//New in Noesis 3.26
	//opens a file stream in binary write mode, using the same path system as the above function. you are responsible for closing the file.
	//use Noesis_FSClose to close the file handle.
	void				*(*Noesis_ExportArchiveFileOpen)(char *filename);

	//new in Noesis 3.27
	//functions similarly to LoadPairedFile, but returns a read-only file handle instead. The file must be closed with Noesis_FSClose
	//when you're done with it.
	void				*(*Noesis_OpenPairedFile)(wchar_t *fileDescr, wchar_t *fileExt, wchar_t *outPath);

	//new in Noesis 3.28
	//calculates tangents (allocates a pooled buffer if tangents is NULL)
	//also triStride should be the size of a *triangle*, not the size of a single index.
	modelTan4_t			*(*rpgCalcTangents)(int numVerts, int numIdx, void *idxData, rpgeoDataType_e idxDataType, int triStride,
												void *posData, rpgeoDataType_e posDataType, int posStride,
												void *nrmData, rpgeoDataType_e nrmDataType, int nrmStride,
												void *uvData, rpgeoDataType_e uvDataType, int uvStride,
												modelTan4_t *tangents, bool reverseWinding);
	bool				(*Noesis_ExportArchiveFileCheckExists)(char *filename);

	//new in Noesis 3.31
	//allocates a noesisTexFr_t for a texture
	noesisTexFr_t		*(*Noesis_TexFrameInfoAlloc)(void);

	//reserved, do not call.
	int					(*resvA)(void);
	int					(*resvB)(void);
	int					(*resvC)(void);
	int					(*resvD)(void);
	int					(*resvE)(void);
	int					(*resvF)(void);
	int					(*resvG)(void);
} noeRAPI_t;

typedef struct noePluginInfo_s
{
	char				pluginName[64];
	char				pluginDesc[512];

	BYTE				resv[512];
} noePluginInfo_t;

//optName, optDescr, and handler must not be NULL or NPAPI_AddTypeOption will fail.
//storeSize must also be > 0.
#define OPTFLAG_WANTARG		(1<<0) //if not set in flags, arg passed will always be NULL
typedef struct addOptParms_s
{
	char			*optName; //MUST START WITH -, e.g. "-maxbones"
	char			*optDescr; //a plain-text description of what this option does
	//your handler should return true if the supplied argument is handled, otherwise false
	bool			(*handler)(const char *arg, unsigned char *store, int storeSize);
	unsigned char	*shareStore; //allows you to provide a store buffer, otherwise one is allocated for you.
	int				storeSize; //the amount of space given for your persistent argument buffer. this memory will be zeroed along with all other model processing options.
	int				flags;
	void			(*storeReset)(unsigned char *store, int storeSize); //optional, allows you to dictate the default contents of your store memory
	int				resv[16];
} addOptParms_t;

typedef struct noePluginFn_s
{
	//=========================
	//engine-provided functions
	//=========================

	//note that rapi handles can be passed from multiple different and concurrent noesis core instances. you should always deal with the local rapi
	//function set.

	//returns a handle to a new type for this module.
	int			(*NPAPI_Register)(char *typeDesc, char *extList);
	//sets the callback for "is this data of this type?"
	void		(*NPAPI_SetTypeHandler_TypeCheck)(int th, bool (*dataCheck)(BYTE *fileBuffer, int bufferLen, noeRAPI_t *rapi));
	//sets the callback to load model data
	void		(*NPAPI_SetTypeHandler_LoadModel)(int th, noesisModel_t *(*loadModel)(BYTE *fileBuffer, int bufferLen, int &numMdl, noeRAPI_t *rapi));
	//sets the callback to write model data
	void		(*NPAPI_SetTypeHandler_WriteModel)(int th, bool (*writeModel)(noesisModel_t *mdl, RichBitStream *outStream, noeRAPI_t *rapi));
	//sets the callback to load pixel data
	void		(*NPAPI_SetTypeHandler_LoadRGBA)(int th, bool (*loadRGBA)(BYTE *fileBuffer, int bufferLen, CArrayList<noesisTex_t *> &noeTex, noeRAPI_t *rapi));
	//sets the callback to write pixel data
	void		(*NPAPI_SetTypeHandler_WriteRGBA)(int th, int (*writeRGBA)(char *fileName, BYTE *pix, int w, int h, noeRAPI_t *rapi));
	//sets the callback to write animation data
	void		(*NPAPI_SetTypeHandler_WriteAnim)(int th, void (*writeAnim)(noesisAnim_t *anim, noeRAPI_t *rapi));
	//sets the callback to extract an archive
	void		(*NPAPI_SetTypeHandler_ExtractArc)(int th, bool (*extractArc)(BYTE *fileBuffer, int bufferLen, bool justChecking, noeRAPI_t *rapi));

	//gets the handle for the main window. make sure to check if this is non-0, as it can be called before the main Noesis window is created.
	HWND		(*NPAPI_GetMainWnd)(void);

	//gets the noesis api version
	int			(*NPAPI_GetAPIVersion)(void);

	//sets the callback to extract an archive in direct-stream mode (new in Noesis 2.5)
	void		(*NPAPI_SetTypeHandler_ExtractArcStream)(int th, bool (*extractArcStream)(wchar_t *filename, __int64 len, bool justChecking, noeRAPI_t *rapi));

	//allows you to add advanced/commandline option hooks for your program (new in Noesis 3.22)
	//if successful, returns a pointer to the variable store for the option.
	void		*(*NPAPI_AddTypeOption)(int th, addOptParms_t *optParms);

	//reserved, do not call.
	int			(*resvA)(void);
	int			(*resvB)(void);
	int			(*resvC)(void);
	int			(*resvD)(void);
	int			(*resvE)(void);
	int			(*resvF)(void);
} noePluginFn_t;

class RichMemFileBase
{
public:
	virtual bool IsValid(void) = 0;
	virtual  __int64 GetSize(void) = 0;
	virtual void Seek(__int64 pos, bool seekRelative) = 0;
	virtual __int64 Tell(void) = 0;
	virtual bool CheckEOF(void) = 0;
	virtual __int64 Read(void *dstBuf, __int64 size) = 0;
	virtual __int64 Write(void *srcBuf, __int64 size) = 0;
};

//quick and dirty encapsulation class for plugins to use with the streaming file functions
class RichFileWrap : public RichMemFileBase
{
public:
	RichFileWrap(wchar_t *filename, noeFSMode_e mode, noeRAPI_t *rapi)
	{
		assert(rapi);
		m_rapi = rapi;
		m_file = rapi->Noesis_FSOpen(filename, mode);
		m_close = true;
	}
	RichFileWrap(void *file, noeRAPI_t *rapi, bool close)
	{
		assert(rapi && file);
		m_rapi = rapi;
		m_file = file;
		m_close = close;
	}
	~RichFileWrap()
	{
		if (m_file && m_close)
		{
			m_rapi->Noesis_FSClose(m_file);
			m_file = NULL;
		}
	}

	inline bool IsValid(void)
	{
		return (m_file && m_rapi);
	}
	inline void *GetFile(void)
	{
		return m_file;
	}
	inline __int64 GetSize(void)
	{
		assert(m_file && m_rapi);
		return m_rapi->Noesis_FSGetSize(m_file);
	}
	inline void Seek(__int64 pos, bool seekRelative)
	{
		assert(m_file && m_rapi);
		m_rapi->Noesis_FSSeek(m_file, pos, seekRelative);
	}
	inline __int64 Tell(void)
	{
		assert(m_file && m_rapi);
		return m_rapi->Noesis_FSTell(m_file);
	}
	inline bool CheckEOF(void)
	{
		assert(m_file && m_rapi);
		return m_rapi->Noesis_FSEOF(m_file);
	}
	inline __int64 Read(void *dstBuf, __int64 size)
	{
		assert(m_file && m_rapi);
		return m_rapi->Noesis_FSRead(dstBuf, size, m_file);
	}
	inline __int64 Write(void *srcBuf, __int64 size)
	{
		assert(m_file && m_rapi);
		return m_rapi->Noesis_FSWrite(srcBuf, size, m_file);
	}
private:
	void		*m_file;
	noeRAPI_t	*m_rapi;
	bool		m_close;
};

//for treating pre-allocated buffers like files. use RichBitStream if you want something self-allocating.
class RichMemFileWrap : public RichMemFileBase
{
public:
	RichMemFileWrap(BYTE *buf, __int64 bufSize)
	{
		m_buf = buf;
		m_bufSize = bufSize;
		m_bufPtr = 0;
	}
	~RichMemFileWrap()
	{
	}

	inline bool IsValid(void)
	{
		return (m_buf && m_bufSize > 0);
	}
	inline BYTE *GetBuffer(void)
	{
		return m_buf;
	}
	inline __int64 GetSize(void)
	{
		return m_bufSize;
	}
	inline void Seek(__int64 pos, bool seekRelative)
	{
		if (seekRelative)
		{
			m_bufPtr += pos;
		}
		else
		{
			m_bufPtr = pos;
		}
		assert(m_bufPtr >= 0 && m_bufPtr <= m_bufSize);
	}
	inline __int64 Tell(void)
	{
		return m_bufPtr;
	}
	inline bool CheckEOF(void)
	{
		return (m_bufPtr >= m_bufSize);
	}
	inline __int64 Read(void *dstBuf, __int64 size)
	{
		assert(m_buf);
		if (!m_buf || m_bufSize <= 0)
		{
			return 0;
		}
		__int64 r = size;
		if (m_bufPtr+r > m_bufSize)
		{
			r -= ((m_bufPtr+r)-m_bufSize);
		}
		if (r <= 0)
		{
			return 0;
		}
		memcpy(dstBuf, m_buf+m_bufPtr, (size_t)r);
		m_bufPtr += r;
		return r;
	}
	inline __int64 Write(void *srcBuf, __int64 size)
	{
		assert(m_buf);
		if (!m_buf || m_bufSize <= 0)
		{
			return 0;
		}
		__int64 r = size;
		if (m_bufPtr+r > m_bufSize)
		{
			r -= ((m_bufPtr+r)-m_bufSize);
		}
		if (r <= 0)
		{
			return 0;
		}
		memcpy(m_buf+m_bufPtr, srcBuf, (size_t)r);
		m_bufPtr += r;
		return r;
	}
private:
	BYTE		*m_buf;
	__int64		m_bufSize;
	__int64		m_bufPtr;
};

#endif
