#ifndef _RM_ANGLES_H_
#define _RM_ANGLES_H_

class RichAngles
{
public:
	RichAngles(void);
	RichAngles(const float pitch, const float yaw, const float roll);
	RichAngles(const float *angles);
	RichAngles(const float *radians, bool scaleToDegrees);

	//access
	float					&operator[](int idx);
	float					operator[](int idx) const;
	//set/compare
	RichAngles				&operator=(const RichAngles &angles);
	bool					operator==(const RichAngles &angles) const;
	bool					operator!=(const RichAngles &angles) const;
	//add
	RichAngles				operator+(const RichAngles &angles) const;
	RichAngles				&operator+=(const RichAngles &angles);
	//subtract
	RichAngles				operator-(void) const;
	RichAngles				operator-(const RichAngles &angles) const;
	RichAngles				&operator-=(const RichAngles &angles);
	//multiply
	RichAngles				operator*(const RichAngles &angles) const;
	RichAngles				&operator*=(const RichAngles &angles);
	RichAngles				operator*(const float &f) const;
	RichAngles				&operator*=(const float &f);
	//divide
	RichAngles				operator/(const RichAngles &angles) const;
	RichAngles				&operator/=(const RichAngles &angles);

	void					ChangeEndian(void);

	//general operations
	void					Mod(float f);
	void					Normalize360(void);
	void					Normalize180(void);
	void					AngleVectors(RichVec3 *fwd, RichVec3 *right, RichVec3 *up) const;
	void					Lerp(const RichAngles &angles, const float frac);
	void					Lerp(const RichAngles &anglesA, const RichAngles &anglesB, const float frac);
	void					ALerp(const RichAngles &angles, const float degrees);
	void					ALerp(const RichAngles &anglesA, const RichAngles &anglesB, const float degrees);

	//conversion
	RichVec3				ToVec3(void) const;
	RichMat43				ToMat43(void) const;
	RichMat43				ToMat43_XYZ(bool yFlip = true) const; //convert using xyz convention
	RichQuat				ToQuat(void) const;

	float					a[3];
};

#endif //_RM_ANGLES_H_
