#ifndef _RM_MATRICES_H_
#define _RM_MATRICES_H_

class RichMat43
{
public:
	RichMat43(void);
	RichMat43(const RichVec3 &r0, const RichVec3 &r1, const RichVec3 &r2, const RichVec3 &trans);
	RichMat43(const modelMatrix_t &mat);
	RichMat43(const float *mat);

	//access
	RichVec3				&operator[](int idx);
	const RichVec3			&operator[](int idx) const;
	//set/compare
	RichMat43				&operator=(const RichMat43 &mat);
	RichMat43				&operator=(const modelMatrix_t &mat);
	bool					operator==(const RichMat43 &mat) const;
	bool					operator!=(const RichMat43 &mat) const;
	//add
	RichMat43				operator+(const RichMat43 &mat) const;
	RichMat43				&operator+=(const RichMat43 &mat);
	//subtract
	RichMat43				operator-(void) const;
	RichMat43				operator-(const RichMat43 &mat) const;
	RichMat43				&operator-=(const RichMat43 &mat);
	//matrix multiply/transform
	RichMat43				operator*(const RichMat43 &mat) const;
	RichMat43				&operator*=(const RichMat43 &mat);
	RichVec3				operator*(const RichVec3 &vec) const;
	RichVec4				operator*(const RichVec4 &vec) const;

	void					ChangeEndian(void);

	//general operations
	RichVec3				TransformPoint(const RichVec3 &vec) const;
	RichVec3				TransformNormal(const RichVec3 &vec) const;
	RichVec4				TransformVec4(const RichVec4 &vec) const;
	RichMat43				GetTranspose(void) const;
	void					Transpose(void);
	RichMat43				GetInverse(void) const;
	void					Inverse(void);
	RichMat43				GetOrthogonalize(bool keepScale = false, bool keepFlip = true, bool straightCross = false) const;
	void					Orthogonalize(bool keepScale = false, bool keepFlip = true, bool straightCross = false);
	bool					IsSkewed(void);
	void					Rotate(float degrees, float x, float y, float z, bool transposeRot = false);
	void					Rotate(float degrees, float *xyz, bool transposeRot = false);
	void					Translate(float x, float y, float z);
	void					Translate(float *xyz);
	void					Lerp(const RichMat43 &postMat, float lerpFrac, bool nonUniform = true, bool orthogonalize = false);
	void					Lerp(const RichMat43 &preMat, const RichMat43 &postMat, float lerpFrac, bool nonUniform = true, bool orthogonalize = false);
	void					SLerp(const RichMat43 &postMat, float lerpFrac, bool nonUniform = true);
	void					SLerp(const RichMat43 &preMat, const RichMat43 &postMat, float lerpFrac, bool nonUniform = true);

	//conversion
	RichQuat				ToQuat(void) const;
	RichAngles				ToAngles(void) const;
	RichMat44				ToMat44(void) const;

	modelMatrix_t			m;
};

//4x4 matrices use opengl conventions (rotation is transposed from 4x3)
class RichMat44
{
public:
	RichMat44(void);
	RichMat44(const RichVec4 &r0, const RichVec4 &r1, const RichVec4 &r2, const RichVec4 &r3);
	RichMat44(const fourxMatrix_t &mat);
	RichMat44(const float *mat);

	//access
	RichVec4				&operator[](int idx);
	const RichVec4			&operator[](int idx) const;
	//set/compare
	RichMat44				&operator=(const RichMat44 &mat);
	RichMat44				&operator=(const fourxMatrix_t &mat);
	bool					operator==(const RichMat44 &mat) const;
	bool					operator!=(const RichMat44 &mat) const;
	//add
	RichMat44				operator+(const RichMat44 &mat) const;
	RichMat44				&operator+=(const RichMat44 &mat);
	//subtract
	RichMat44				operator-(void) const;
	RichMat44				operator-(const RichMat44 &mat) const;
	RichMat44				&operator-=(const RichMat44 &mat);
	//matrix multiply/transform
	RichMat44				operator*(const RichMat44 &mat) const;
	RichMat44				&operator*=(const RichMat44 &mat);
	RichVec4				operator*(const RichVec4 &vec) const;

	void					ChangeEndian(void);

	//general operations
	RichVec4				TransformVec4(const RichVec4 &vec) const;
	RichMat44				GetTranspose(void) const;
	void					Transpose(void);
	RichMat44				GetInverse(void) const;
	void					Inverse(void);
	void					Rotate(float degrees, float x, float y, float z);
	void					Rotate(float degrees, float *xyz);
	void					Translate(float x, float y, float z);
	void					Translate(float *xyz);

	//conversion
	RichMat43				ToMat43(void) const;

	fourxMatrix_t			m;
};

#endif //_RM_MATRICES_H_
