#ifndef _RM_QUATS_H_
#define _RM_QUATS_H_

class RichQuat
{
public:
	RichQuat(void);
	RichQuat(const float x, const float y, const float z, const float w);
	RichQuat(const float *xyzw);
	RichQuat(const float *xyz, const bool noW);

	//access
	float					&operator[](int idx);
	float					operator[](int idx) const;
	//set/compare
	RichQuat				&operator=(const RichQuat &quat);
	bool					operator==(const RichQuat &quat) const;
	bool					operator!=(const RichQuat &quat) const;
	//add
	RichQuat				operator+(const RichQuat &quat) const;
	RichQuat				&operator+=(const RichQuat &quat);
	//subtract
	RichQuat				operator-(void) const;
	RichQuat				operator-(const RichQuat &quat) const;
	RichQuat				&operator-=(const RichQuat &quat);
	//multiply
	RichQuat				operator*(const RichQuat &quat) const;
	RichQuat				&operator*=(const RichQuat &quat);
	RichVec3				operator*(const RichVec3 &vec) const;
	RichQuat				operator*(const float &f) const;
	RichQuat				&operator*=(const float &f);

	void					ChangeEndian(void);

	//general operations
	RichVec3				TransformPoint(const RichVec3 &vec) const;
	RichQuat				GetTranspose(void);
	void					Transpose(void);
	float					Length(void) const;
	float					Normalize(void);
	void					Lerp(const RichQuat &quat, const float frac);
	void					Lerp(const RichQuat &quatA, const RichQuat &quatB, const float frac);
	void					SLerp(const RichQuat &quat, const float frac);
	void					SLerp(const RichQuat &quatA, const RichQuat &quatB, const float frac);

	//conversion
	void					FromQuat3(const float *quat); //derive the w
	void					ToQuat3(float *quat) const;
	RichMat43				ToMat43(bool transposed = false) const;
	RichAngles				ToAngles(void) const;

	float					q[4];
};

#endif //_RM_QUATS_H_
