#ifndef _RM_VECTORS_H_
#define _RM_VECTORS_H_

class RichVec3
{
public:
	RichVec3(void);
	RichVec3(const float x, const float y, const float z);
	RichVec3(const float *xyz);

	//access
	float					&operator[](int idx);
	float					operator[](int idx) const;
	//set/compare
	RichVec3				&operator=(const RichVec3 &vec);
	bool					operator==(const RichVec3 &vec) const;
	bool					operator!=(const RichVec3 &vec) const;
	//add
	RichVec3				operator+(const RichVec3 &vec) const;
	RichVec3				&operator+=(const RichVec3 &vec);
	//subtract
	RichVec3				operator-(void) const;
	RichVec3				operator-(const RichVec3 &vec) const;
	RichVec3				&operator-=(const RichVec3 &vec);
	//multiply
	RichVec3				operator*(const RichVec3 &vec) const;
	RichVec3				&operator*=(const RichVec3 &vec);
	RichVec3				operator*(const float &f) const;
	RichVec3				&operator*=(const float &f);
	//divide
	RichVec3				operator/(const RichVec3 &vec) const;
	RichVec3				&operator/=(const RichVec3 &vec);

	void					ChangeEndian(void);

	//general operations
	float					Dot(const RichVec3 &vec) const;
	RichVec3				Cross(const RichVec3 &vec) const;
	void					Cross(const RichVec3 &vecA, const RichVec3 &vecB);
	float					Length(void) const;
	float					LengthSq(void) const;
	float					Normalize(void);
	RichVec3				Normalize(void) const;
	void					Lerp(const RichVec3 &vec, const float frac);
	void					Lerp(const RichVec3 &vecA, const RichVec3 &vecB, const float frac);

	//conversion
	RichAngles				ToAngles(void) const;
	RichVec4				ToVec4(void) const;
	RichMat43				ToMat43(void) const;

	float					v[3];
};

class RichVec4
{
public:
	RichVec4(void);
	RichVec4(const float x, const float y, const float z, const float w);
	RichVec4(const float *xyzw);
	RichVec4(const RichVec3 &xyz, const float w);

	//access
	float					&operator[](int idx);
	float					operator[](int idx) const;
	//set/compare
	RichVec4				&operator=(const RichVec4 &vec);
	bool					operator==(const RichVec4 &vec) const;
	bool					operator!=(const RichVec4 &vec) const;
	//add
	RichVec4				operator+(const RichVec4 &vec) const;
	RichVec4				&operator+=(const RichVec4 &vec);
	//subtract
	RichVec4				operator-(void) const;
	RichVec4				operator-(const RichVec4 &vec) const;
	RichVec4				&operator-=(const RichVec4 &vec);
	//multiply
	RichVec4				operator*(const RichVec4 &vec) const;
	RichVec4				&operator*=(const RichVec4 &vec);
	RichVec4				operator*(const float &f) const;
	RichVec4				&operator*=(const float &f);
	//divide
	RichVec4				operator/(const RichVec4 &vec) const;
	RichVec4				&operator/=(const RichVec4 &vec);

	void					ChangeEndian(void);

	//general operations
	float					Dot(const RichVec4 &vec) const;
	float					Length(void) const;
	float					LengthSq(void) const;
	float					Normalize(void);
	RichVec4				Normalize(void) const;
	void					Lerp(const RichVec4 &vec, const float frac);
	void					Lerp(const RichVec4 &vecA, const RichVec4 &vecB, const float frac);

	//conversion
	RichVec3				ToVec3(void) const;

	float					v[4];
};

#endif //_RM_VECTORS_H_
